//
//  YHTravelCertificateTipsView.swift
//  galaxy
//
//  Created by edy on 2024/8/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHTravelCertificateTipsView: UIView {

    var text: ASAttributedString = .init("") {
        didSet {
            tipsLabel.attributed.text = text
        }
    }
    
    var dotView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor(alpha: 0.16)
        view.layer.cornerRadius = 1.0
        view.clipsToBounds = true
        return view
    }()
    
    var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor(alpha: 0.5)
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 0
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(dotView)
        self.addSubview(tipsLabel)
        
        dotView.snp.makeConstraints { make in
            make.width.height.equalTo(4)
            make.left.equalTo(0)
            make.top.equalTo(8)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.equalTo(dotView.snp.right).offset(7.0)
            make.right.equalTo(0)
            make.bottom.equalTo(0)
        }
    }
}
